import { transformAgenciesResponse } from "@/lib/transformers";
import { validatedFetch } from "@/lib/zod/validated-fetch";
import { otpFeedStatusesResponseSchema } from "@/zod/feeds.schema";

/**
 * Returns the current set of agencies known by the system
 * along with their statuses:
 *
 * - Date files were uploaded
 * - Date uploaded to preview otp server
 * - Date uploaded to live otp server
 */
export const getAgencies = async () => {
  const url = '/api/statuses'
  const res = await validatedFetch({
    url: url,
    schema: otpFeedStatusesResponseSchema,
  })

  if (typeof res === 'object' && 'error' in res) {
    throw new Error(`getAgencies: Unable to properly get agencies from api route ${url}. Message Thrown (${res?.error})`)
  } else if (res instanceof Error) {
    throw new Error(`getAgencies: Unable to properly get agencies from api route ${url}. Message Thrown (${res.name}, ${res.message})`, {
      cause: res.cause,
    })
  }

  return transformAgenciesResponse(res)
};

